VERSION 5.00
Object = "{248DD890-BB45-11CF-9ABC-0080C7E7B78D}#1.0#0"; "MSWINSCK.OCX"
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "comctl32.ocx"
Object = "{3B7C8863-D78F-101B-B9B5-04021C009402}#1.2#0"; "RICHTX32.OCX"
Begin VB.Form Form1 
   BackColor       =   &H00C0FFC0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "U3800 LAN GetTrace Ver. 1.1"
   ClientHeight    =   7785
   ClientLeft      =   3195
   ClientTop       =   1605
   ClientWidth     =   9480
   BeginProperty Font 
      Name            =   "Arial"
      Size            =   9
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "Form1.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   7785
   ScaleWidth      =   9480
   Begin VB.CheckBox AutoSaveFlag 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Auto Save IQ (CSV)"
      Height          =   255
      Left            =   960
      TabIndex        =   14
      ToolTipText     =   "Select Auto Save I_Q data On/Off"
      Top             =   7080
      Value           =   1  'Checked
      Width           =   2055
   End
   Begin VB.CheckBox DspNumber 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Display Number"
      Height          =   255
      Left            =   4440
      TabIndex        =   20
      ToolTipText     =   "Select Display Point Number On/Off"
      Top             =   7080
      Value           =   1  'Checked
      Width           =   1815
   End
   Begin VB.Frame Frame1 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Display Step Size"
      Height          =   1335
      Left            =   7320
      TabIndex        =   33
      Top             =   5880
      Width           =   1935
      Begin VB.TextBox Text2 
         Height          =   330
         Left            =   1080
         TabIndex        =   21
         Top             =   360
         Width           =   735
      End
      Begin VB.TextBox Text5 
         Height          =   330
         Left            =   1080
         TabIndex        =   22
         Text            =   "1000"
         Top             =   840
         Width           =   735
      End
      Begin VB.OptionButton Option2 
         BackColor       =   &H00C0FFC0&
         Caption         =   "Manual"
         Height          =   255
         Left            =   120
         TabIndex        =   19
         ToolTipText     =   "Select Display Mode: Manual"
         Top             =   840
         Width           =   975
      End
      Begin VB.OptionButton Option1 
         BackColor       =   &H00C0FFC0&
         Caption         =   "Auto"
         Height          =   255
         Left            =   120
         TabIndex        =   18
         ToolTipText     =   "Select Dispaly Mode: Auto"
         Top             =   360
         Value           =   -1  'True
         Width           =   855
      End
   End
   Begin VB.CommandButton IQ_Next 
      Caption         =   "Get Next Block"
      Height          =   375
      Left            =   7560
      TabIndex        =   6
      ToolTipText     =   "Get Next IQ Data"
      Top             =   5280
      Width           =   1455
   End
   Begin VB.TextBox Text4 
      Height          =   285
      Left            =   7440
      TabIndex        =   16
      Top             =   4200
      Width           =   1695
   End
   Begin VB.TextBox Text3 
      Height          =   285
      Left            =   7440
      TabIndex        =   15
      Top             =   3600
      Width           =   1695
   End
   Begin VB.TextBox Text1 
      Height          =   285
      Left            =   7560
      TabIndex        =   17
      Top             =   4800
      Width           =   1455
   End
   Begin VB.CommandButton Get_IQ_Data 
      Caption         =   "Get  IQ Data"
      Height          =   375
      Left            =   7560
      TabIndex        =   5
      ToolTipText     =   "Get IQ Data = Real(Single)"
      Top             =   2520
      Width           =   1455
   End
   Begin RichTextLib.RichTextBox RichTextBox2 
      Height          =   2775
      Left            =   3720
      TabIndex        =   13
      Top             =   4200
      Width           =   3135
      _ExtentX        =   5530
      _ExtentY        =   4895
      _Version        =   393217
      Enabled         =   -1  'True
      ScrollBars      =   2
      TextRTF         =   $"Form1.frx":0442
   End
   Begin RichTextLib.RichTextBox RichTextBox1 
      Height          =   2775
      Left            =   240
      TabIndex        =   12
      Top             =   4200
      Width           =   3135
      _ExtentX        =   5530
      _ExtentY        =   4895
      _Version        =   393217
      Enabled         =   -1  'True
      ScrollBars      =   2
      TextRTF         =   $"Form1.frx":04CF
   End
   Begin VB.CheckBox chkMon 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Monitor"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   5400
      TabIndex        =   34
      ToolTipText     =   "Monitor On/Off"
      Top             =   1680
      Width           =   1035
   End
   Begin VB.CommandButton cmdEnd 
      BackColor       =   &H00C0C0FF&
      Caption         =   "EXIT"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   435
      Left            =   7680
      Style           =   1  'Graphical
      TabIndex        =   3
      ToolTipText     =   "Exit from this software"
      Top             =   1560
      Width           =   1215
   End
   Begin VB.CommandButton cmdTrace 
      BackColor       =   &H0080FF80&
      Caption         =   "Waveform View"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   675
      Left            =   5400
      Style           =   1  'Graphical
      TabIndex        =   1
      ToolTipText     =   "Display SA Waveform"
      Top             =   600
      Width           =   1935
   End
   Begin VB.ListBox lstRecv 
      Height          =   1410
      ItemData        =   "Form1.frx":055C
      Left            =   240
      List            =   "Form1.frx":055E
      TabIndex        =   11
      Top             =   2160
      Width           =   6615
   End
   Begin ComctlLib.StatusBar sbrMessage 
      Align           =   2  'Align Bottom
      Height          =   345
      Left            =   0
      TabIndex        =   10
      Top             =   7440
      Width           =   9480
      _ExtentX        =   16722
      _ExtentY        =   609
      Style           =   1
      SimpleText      =   ""
      _Version        =   327682
      BeginProperty Panels {0713E89E-850A-101B-AFC0-4210102A8DA7} 
         NumPanels       =   1
         BeginProperty Panel1 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            Object.Tag             =   ""
         EndProperty
      EndProperty
   End
   Begin VB.CommandButton cmdDisConn 
      BackColor       =   &H00FFFFC0&
      Caption         =   "Close"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   435
      Left            =   7680
      Style           =   1  'Graphical
      TabIndex        =   2
      ToolTipText     =   "Disconnect from SA"
      Top             =   720
      Width           =   1215
   End
   Begin VB.CommandButton cmdSend 
      Caption         =   "SendText"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   435
      Left            =   3840
      TabIndex        =   4
      ToolTipText     =   "Sending a command to SA"
      Top             =   1560
      Width           =   1215
   End
   Begin VB.CommandButton cmdConnect 
      BackColor       =   &H00FFFFC0&
      Caption         =   "Connect"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   435
      Left            =   3840
      Style           =   1  'Graphical
      TabIndex        =   0
      ToolTipText     =   "Connect to SA"
      Top             =   720
      Width           =   1215
   End
   Begin VB.TextBox txtPort 
      Height          =   270
      Left            =   2760
      TabIndex        =   9
      Text            =   "5025"
      Top             =   840
      Width           =   735
   End
   Begin VB.TextBox txtSend 
      Height          =   270
      Left            =   480
      TabIndex        =   7
      Text            =   "*IDN?"
      Top             =   1680
      Width           =   3015
   End
   Begin VB.TextBox txtHost 
      Height          =   255
      Left            =   480
      TabIndex        =   8
      Text            =   "192.168.0.1"
      Top             =   840
      Width           =   1995
   End
   Begin MSWinsockLib.Winsock tcpClient 
      Left            =   8040
      Top             =   120
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
   Begin VB.Label Label9 
      BackColor       =   &H00C0FFC0&
      Caption         =   "I_Q Scale:"
      Height          =   255
      Left            =   7920
      TabIndex        =   31
      Top             =   3960
      Width           =   975
   End
   Begin VB.Label Label8 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Sampling Clock (Hz):"
      Height          =   255
      Left            =   7440
      TabIndex        =   30
      Top             =   3360
      Width           =   1815
   End
   Begin VB.Line Line2 
      BorderColor     =   &H80000002&
      X1              =   7080
      X2              =   9360
      Y1              =   2160
      Y2              =   2160
   End
   Begin VB.Label Label7 
      BackColor       =   &H00C0FFC0&
      Caption         =   "(@TDA Mode)"
      Height          =   255
      Left            =   7680
      TabIndex        =   29
      Top             =   2880
      Width           =   1215
   End
   Begin VB.Line Line4 
      BorderColor     =   &H80000002&
      X1              =   7080
      X2              =   7080
      Y1              =   2160
      Y2              =   7320
   End
   Begin VB.Line Line1 
      BorderColor     =   &H80000002&
      X1              =   120
      X2              =   7080
      Y1              =   3840
      Y2              =   3840
   End
   Begin VB.Label Label5 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Sample Points:"
      Height          =   255
      Left            =   7680
      TabIndex        =   32
      Top             =   4560
      Width           =   1335
   End
   Begin VB.Label Label4 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Q Data :"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   3840
      TabIndex        =   28
      Top             =   3960
      Width           =   855
   End
   Begin VB.Label Label3 
      BackColor       =   &H00C0FFC0&
      Caption         =   "I Data :"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   360
      TabIndex        =   27
      Top             =   3960
      Width           =   855
   End
   Begin VB.Label Label2 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "U3800 Waveform Viewer via LAN"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   14.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00C00000&
      Height          =   315
      Left            =   1800
      TabIndex        =   23
      Top             =   60
      Width           =   5355
   End
   Begin VB.Label Label1 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Sending Text:"
      Height          =   195
      Index           =   2
      Left            =   480
      TabIndex        =   26
      Top             =   1440
      Width           =   1215
   End
   Begin VB.Label Label1 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Port No."
      Height          =   195
      Index           =   1
      Left            =   2760
      TabIndex        =   25
      Top             =   600
      Width           =   855
   End
   Begin VB.Label Label1 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Host Address:"
      Height          =   195
      Index           =   0
      Left            =   480
      TabIndex        =   24
      Top             =   600
      Width           =   1335
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'*----------------------------------------------------------------------
'*.Program Name :        LAN Remote SPA Viewer
'*
'*      Sample software for Advantest Spectrum Analyzer U37xx
'*
'*.Description :
'*
'*.Revision History :
'*      1.00           1-JAN-2006       First Release. by Ogino
'*      1.40           1-Mar-2010       1.4   Release. by Hirakoso
'*                                            Add IQ-data reading
'*
'*      U3800 V10      7-DEC-2011       V1.0  Release for U3800
'*                                              by Hirakoso
'*
'*      U3800 V11      28-AUG-2012      V1.1  Addtion I_Q Data Menu
'*                                            Sampling Clock, Sampling Points
'*                                            IQ Scale, Get Next IQ Data
'*                                            Display Number On/Off
'*                                              by Hirakoso
'*
'*
'*----------------------------------------------------------------------
'*.Copyright(c) 2006,2010,2012 ADVANTEST CORPORATION
'*.http://www.advantest.co.jp
'*----------------------------------------------------------------------

Dim exitFg As Integer
'-----------------------------------------------



Private Sub cmdEnd_Click()
Dim i
    exitFg = 1
    Debug.Print "Forms", Forms.Count
    For i = 0 To Forms.Count - 1
        Unload Forms(i)
    Next i
    
    SetupLAN = 0

End Sub



Private Sub cmdDisConn_Click()
    Dim ErrRet As Integer

    ErrRet = SendDtFunc("GTL")
    sbrMessage.SimpleText = "Closing..."
    tcpClient.Close
    sbrMessage.SimpleText = "Closed"
        
    cmdConnect.Enabled = True
    cmdConnect.Default = True
    cmdDisConn.Enabled = False
    cmdEnd.Enabled = True
    
    txtHost.Enabled = True
    txtPort.Enabled = True
    txtHost.SetFocus
    
    SetupLAN = 0
    
End Sub



Private Sub cmdConnect_Click()
Dim Sp As String
Dim SendDt As String, ErrRet As Integer
    
    If Trim$(txtHost.Text) <> "" And _
      Trim$(txtPort.Text) <> "" Then
    'AvP[Vɐڑv𑗐M܂
        tcpClient.Protocol = sckTCPProtocol
        tcpClient.LocalPort = 0
        tcpClient.RemoteHost = txtHost.Text
        tcpClient.RemotePort = txtPort.Text
        tcpClient.Connect
        sbrMessage.SimpleText = "Connecting..."
            
        Do While (tcpClient.BytesReceived = 0)
            DoEvents
        Loop
        tcpClient.GetData Sp
        lstRecv.AddItem tcpClient.RemoteHost & "-->" & Sp
        ErrRet = SendDtFunc("REN")

        cmdTrace.Default = True
        cmdDisConn.Enabled = True
        cmdConnect.Enabled = False
        cmdEnd.Enabled = False
        
        txtSend.SetFocus
        
        SetupLAN = 1
        
    Else

        MsgBox "Please input the IP Address"
        SetupLAN = 0
        
    End If
    
End Sub



Private Sub cmdSend_Click()
Dim SendDt As String, ErrRet As Integer
Dim RcvDt As String
Dim dTimer As Double, iErrFg As Integer


If SetupLAN = 1 Then

    IQ_Next.Enabled = False                 'Get Next Block ---> No Active

    ErrRet = SendDtFunc("REN")              'Remote setting
    If ErrRet <> 0 Then Exit Sub
                                            'SendDt = CMD_DATA + txtSend.Text
    SendDt = txtSend.Text
    ErrRet = SendDtFunc(SendDt)
    If ErrRet <> 0 Then Exit Sub
    
    iErrFg = 0
    dTimer = Timer
    If InStr(SendDt, "?") > 0 Then
'        ErrRet = SendDtFunc(SendDt)
        Do While (tcpClient.BytesReceived = 0)
            DoEvents
            If Timer > dTimer + 10# Then
                iErrFg = 1
                Exit Do
            End If
        Loop
        If iErrFg = 0 Then
            tcpClient.GetData RcvDt
            lstRecv.AddItem tcpClient.RemoteHost & "-->" & RcvDt
        Else
            lstRecv.AddItem tcpClient.RemoteHost & "-->" & "Query error!"
        End If
        lstRecv.ListIndex = Form1.lstRecv.ListCount - 1
   End If
   
Else

    MsgBox "Please open the LAN: Connect button..."

End If

End Sub


Private Sub cmdTrace_Click()

If SetupLAN = 1 Then

    IQ_Next.Enabled = False                     'Get Next Block ---> No Active

    Call SendDtFunc("REN")                      'Set remote
    Call SendDtFunc("CONTS")                    'Cont Sweep
    Call SendDtFunc("FORM1")                    'Trace data out format -> BIN 16bits

    DispForm.Show vbModal
    
Else

    MsgBox "Please open the LAN: Connect button..."

End If


End Sub


Private Sub Form_Load()

exitFg = 0
SizeValue = 0
DataGetFg = False   'DataǂłȂ
GridType = 0        '
GridDivX = 10       '10
GridDivY = 10       'c10

'DispForm.Show

cmdDisConn.Enabled = False              ' No Active

IQ_Next.Enabled = False                 ' No Active

cmdConnect.Default = True               ' Focus


End Sub


Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
If exitFg <> 0 Then Exit Sub

MsgBox "Use Close & EXIT button for quit.", vbOKOnly, App.Title
Cancel = -1

End Sub


Private Sub Form_Unload(Cancel As Integer)
End
End Sub


'***************************************** Get IQ Data First Block ****************
Private Sub Get_IQ_Data_Click()

Dim IQptsbuf As String
Dim i As Long, DataCnt As Long
Dim bTrc() As Byte
Dim TempBuf As Byte


If SetupLAN = 1 Then

    Get_IQ_Data.Enabled = False                 'Key  ---> No Active
    
    IQ_Next.Enabled = False                     'Get Next Block ---> No Active

    '-------------------------------------------'Message Display
    Form1.lstRecv.AddItem Form1.tcpClient.RemoteHost & "-->" & "Get IQ Data (1st Block)"
    Form1.lstRecv.ListIndex = Form1.lstRecv.ListCount - 1
    If Form1.lstRecv.ListCount > 100 Then
        Form1.lstRecv.RemoveItem 0
    End If
    
    sbrMessage.SimpleText = "Getting I_Q data, now..."
    sbrMessage.Refresh
    
    Text1.Text = ""                             'Clear Sampling Points
    Text2.Text = ""                             'Clear Step Size Auto
    Text3.Text = ""                             'Clear Sampling Clock
    Text4.Text = ""                             'Clear IQ Scale
    
    RichTextBox1.Text = ""
    RichTextBox2.Text = ""
    
    DoEvents

    '----------------------------------------------------------------------
    Call SendDtFunc("REN")                      'Set remote
    
    Call SendDtFunc("AW; BW")                   'A,B Trace ON
    Call SendDtFunc("TS")                       'Measurement: 1 Sweep & wait
    
    Call SendDtFunc("IQR?")                     'Sampling Clock
    IQptsbuf = Space(20)
    IQptsbuf = RcvDtFunc
    Text3.Text = Val(IQptsbuf)
    
    Call SendDtFunc("IQS?")                     'IQ Scale
    IQptsbuf = Space(20)
    IQptsbuf = RcvDtFunc
    Text4.Text = Val(IQptsbuf)
    
    Call SendDtFunc("IQP?")                     'Trace Points
    IQptsbuf = Space(20)
    IQptsbuf = RcvDtFunc
    IQpts = Val(IQptsbuf)                       'String to Long
    Text1.Text = IQpts                          'Display Sample Points
    
    DoEvents
    
    '----------------------------------------------------------------------
    
    If Option1.Value = True Then                'Step Auto or Manual?
    
        DspStep = IQpts / 10000                 'Auto: fixed calcu
        If DspStep < 1 Then DspStep = 1
        Text2.Text = DspStep                    'Display step data
    Else
    
        DspStep = Val(Text5)                    'Manual Data
        If DspStep < 1 Then DspStep = 1
        Text5.Text = DspStep                    'Display step data
    End If
    
    '----------------------------------------------------------------------
    Call SendDtFunc("DLIM2")                    'Delimiter EOI
    
    Call SendDtFunc("IQB?")                     'Trace Data ?
    
    Erase bTrc
    Do While (Form1.tcpClient.BytesReceived < IQpts * 8)    'Data end?
        DoEvents
    Loop
    
    Form1.tcpClient.GetData bTrc                'Get Data (Bytes)
    
    DoEvents
    
    '----------------------------------------------------------------------
    DataCnt = 0                                 'I & Q Data counter
    
    For i = 0 To ((IQpts - 1) * 8) Step 8       'I & Q data = 8 Bytes
    
'        TempBuf = bTrc(i)                       'I data: a,b,c,d --> d,c,b,a
'        bTrc(i) = bTrc(i + 3)
'        bTrc(i + 3) = TempBuf
'
'        TempBuf = bTrc(i + 1)
'        bTrc(i + 1) = bTrc(i + 2)
'        bTrc(i + 2) = TempBuf
        
        Call CopyValtoVal(TrIQ(DataCnt, 0), bTrc(i), IEEE_FLOAT_BYTE)
        
        '-----
'        TempBuf = bTrc(i + 4)                   'Q data: a,b,c,d --> d,c,b,a
'        bTrc(i + 4) = bTrc(i + 7)
'        bTrc(i + 7) = TempBuf
'
'        TempBuf = bTrc(i + 5)
'        bTrc(i + 5) = bTrc(i + 6)
'        bTrc(i + 6) = TempBuf
        
        Call CopyValtoVal(TrIQ(DataCnt, 1), bTrc(i + 4), IEEE_FLOAT_BYTE)
        
        DataCnt = DataCnt + 1                   'Next Data Counter
               
    Next i
    

    '--------------------------------------------------------------------
    
    SaveFileNo = 1                               'for Data Save File name
    
    If AutoSaveFlag.Value = 1 Then
        SaveData (SaveFileNo)                    'Save Data to CSV-File
    End If
    
    '--------------------------------------------------------------------
    
    If DspNumber.Value = 1 Then
    
        For i = 0 To (IQpts - 1) Step DspStep
            RichTextBox1.SelText = Str(i) & " :  " & Str(TrIQ(i, 0)) & vbCrLf
            RichTextBox2.SelText = Str(i) & " :  " & Str(TrIQ(i, 1)) & vbCrLf
        Next i
        
        IQptsMemory = i                         'for Next Block Data Number
        
    Else
    
        For i = 0 To (IQpts - 1) Step DspStep
            RichTextBox1.SelText = Str(TrIQ(i, 0)) & vbCrLf
            RichTextBox2.SelText = Str(TrIQ(i, 1)) & vbCrLf
        Next i
        
    End If
         
    '------------------------------------------------------------------------------
    '   Next IQ Data Check
    '------------------------------------------------------------------------------
    
    Call SendDtFunc("IQP?")                     'Trace Points
    IQptsbuf = Space(20)
    IQptsbuf = RcvDtFunc
    IQpts = IQptsbuf                            'String to Long ---> Next Points Data
    
    If IQpts > 0 Then
    
    
        '-------------------------------------------'Message Display
        Form1.lstRecv.AddItem "----->Get Next Block Data" + Str(SaveFileNo + 1) + ", Please press the Get Next Block-key"
        Form1.lstRecv.ListIndex = Form1.lstRecv.ListCount - 1
        If Form1.lstRecv.ListCount > 100 Then
            Form1.lstRecv.RemoveItem 0
        End If
        
        sbrMessage.SimpleText = "End of Getting Data..."
        sbrMessage.Refresh
        
        Call SendDtFunc("DLIM0")                    'Delimiter CRLF
        
        IQ_Next.Enabled = True                      'Active
    
    Else
    
        Call SendDtFunc("DLIM0")                    'Delimiter CRLF
        
        Call SendDtFunc("CONTS")                    'Cont Sweep
        
        '-------------------------------------------'Message Display
        Form1.lstRecv.AddItem "----->" & "End of Getting Data, Coverting & Display"
        Form1.lstRecv.ListIndex = Form1.lstRecv.ListCount - 1
        If Form1.lstRecv.ListCount > 100 Then
            Form1.lstRecv.RemoveItem 0
        End If
        
        sbrMessage.SimpleText = "End of Getting Data..."
        sbrMessage.Refresh
        
    End If
    
    Get_IQ_Data.Enabled = True                          'Get IQ_Data Key  ---> Active
        
Else                                                    'Not Remote

    MsgBox "Please open the LAN: Connect button..."

End If

Beep                                                'End...

End Sub


'***************************************** Get IQ Data Next Block ****************
Private Sub IQ_Next_Click()

Dim IQptsbuf As String
Dim i As Long, DataCnt As Long
Dim bTrc() As Byte
Dim TempBuf As Byte

    sbrMessage.SimpleText = "Getting I_Q data, now..."
    sbrMessage.Refresh
    
    Get_IQ_Data.Enabled = False                 'Key  ---> No Active
    IQ_Next.Enabled = False                     'Key  ---> No Active

    Call SendDtFunc("REN")                      'Set remote

    Call SendDtFunc("DLIM2")                    'Delimiter EOI
    
    Text1.Text = IQpts                          'Display Sample Points
    
    Call SendDtFunc("IQB?")                     'Trace Data ?
    
    Erase bTrc
    Do While (Form1.tcpClient.BytesReceived < IQpts * 8)    'Data end?
        DoEvents
    Loop
    
    Form1.tcpClient.GetData bTrc                'Get Data (Bytes)
    
    DoEvents
    
    '----------------------------------------------------------------------
    DataCnt = 0                                 'I & Q Data counter
    
    For i = 0 To ((IQpts - 1) * 8) Step 8       'I & Q data = 8 Bytes
    
        Call CopyValtoVal(TrIQ(DataCnt, 0), bTrc(i), IEEE_FLOAT_BYTE)
        
        Call CopyValtoVal(TrIQ(DataCnt, 1), bTrc(i + 4), IEEE_FLOAT_BYTE)
        
        DataCnt = DataCnt + 1                   'Next Data Counter
               
    Next i
    

    '----------------------------------------------------------------------------
    
    SaveFileNo = SaveFileNo + 1                 'for Data Save File name
    
    If AutoSaveFlag.Value = 1 Then
        SaveData (SaveFileNo)                    'Save Data to CSV-File
    End If
    
    '----------------------------------------------------------------------------
    
    
    If DspNumber.Value = 1 Then
    
        For i = 0 To (IQpts - 1) Step DspStep
            RichTextBox1.SelText = Str(i + IQptsMemory) & " :  " & Str(TrIQ(i, 0)) & vbCrLf
            RichTextBox2.SelText = Str(i + IQptsMemory) & " :  " & Str(TrIQ(i, 1)) & vbCrLf
        Next i
        
        IQptsMemory = IQptsMemory + i           'for Next Block Data Number
        
    Else
    
        For i = 0 To (IQpts - 1) Step DspStep
            RichTextBox1.SelText = Str(TrIQ(i, 0)) & vbCrLf
            RichTextBox2.SelText = Str(TrIQ(i, 1)) & vbCrLf
        Next i
        
    End If
    
    
    '------------------------------------------------------------------------------
    '   Next IQ Data Check
    '------------------------------------------------------------------------------
    
    Call SendDtFunc("IQP?")                     'Trace Points
    IQptsbuf = Space(20)
    IQptsbuf = RcvDtFunc
    IQpts = Val(IQptsbuf)                       'String to Long
    
    If IQpts > 0 Then
    
        '-------------------------------------------'Message Display
        Form1.lstRecv.AddItem "----->Get Next Block Data" + Str(SaveFileNo + 1) + ", Please press the Get Next Block-key"
        Form1.lstRecv.ListIndex = Form1.lstRecv.ListCount - 1
        If Form1.lstRecv.ListCount > 100 Then
            Form1.lstRecv.RemoveItem 0
        End If
        
        sbrMessage.SimpleText = "End of Getting Data..."
        sbrMessage.Refresh
        
        IQ_Next.Enabled = True                      ' Get Next Block ---> Active
        
        Call SendDtFunc("DLIM0")                    'Delimiter CRLF
    
    Else
    
        Call SendDtFunc("DLIM0")                    'Delimiter CRLF
        
        Call SendDtFunc("CONTS")                    'Cont Sweep
        
        '-------------------------------------------'Message Display
        Form1.lstRecv.AddItem "----->" & "End of Getting Data, Coverting & Display"
        Form1.lstRecv.ListIndex = Form1.lstRecv.ListCount - 1
        If Form1.lstRecv.ListCount > 100 Then
            Form1.lstRecv.RemoveItem 0
        End If
        
        sbrMessage.SimpleText = "End of Getting Data..."
        sbrMessage.Refresh
        
        IQ_Next.Enabled = False                     ' No Next Block ---> No Active
        
    End If
    
    Get_IQ_Data.Enabled = True                      'Key  ---> No Active
    Beep                                            'End...
    

End Sub

'------------------------------------------------------------------------'Data Save to File
Public Sub SaveData(DataNo As Integer)
'
Dim MeasCnt As Long
Dim DataNoCSV As String, SaveFileText As String

On Error GoTo ErrProcData

    DataNoCSV = DataNo

    SaveFileText = App.Path + "\IQ_Data" + DataNoCSV + "-" + Format(Now, "yyyymmddhhnn") + ".csv"
    
    Open SaveFileText For Output As #1
    
    For MeasCnt = 0 To (IQpts - 1)                               'Measurement Number
    
        Write #1, TrIQ(MeasCnt, 0); TrIQ(MeasCnt, 1)
        
    Next MeasCnt
        
    Close #1
    
    sbrMessage.SimpleText = "Save the data: Done..."
    sbrMessage.Refresh

    Exit Sub                                                    'EXIT------------
    
ErrProcData:                                                    'Error

    Close #1
    
    sbrMessage.SimpleText = "Error: The save directory name was not found.  or etc..."
    sbrMessage.Refresh
    
    MsgBox "Error: Please check the save directory name. and Retry ! ", vbQuestion, App.Title
    

End Sub


Private Sub tcpClient_Close()
'ڑؒf܂
    sbrMessage.SimpleText = "Closed"
    sbrMessage.Refresh
End Sub


Private Sub tcpClient_Connect()
'ڑ܂
Dim Sp As String
Dim SendDt As String, ErrRet As Integer

    sbrMessage.SimpleText = "Connected with " & _
                      tcpClient.RemoteHost & ":" & _
                      tcpClient.RemotePort
    sbrMessage.Refresh

End Sub

Private Sub tcpClient_ConnectionRequest(ByVal requestID As Long)
Debug.Print "ConnectionReques", requestID

End Sub

Private Sub tcpClient_DataArrival(ByVal bytesTotal As Long)
'f[^͂܂
    Dim strBuf      As String

End Sub

Private Sub tcpClient_Error(ByVal Number As Integer, Description As String, ByVal Scode As Long, ByVal Source As String, ByVal HelpFile As String, ByVal HelpContext As Long, CancelDisplay As Boolean)
Debug.Print "Error", Number, Description, Source

End Sub

Private Sub tcpClient_SendComplete()
'Debug.Print "SendComplete"

End Sub

Private Sub tcpClient_SendProgress(ByVal bytesSent As Long, ByVal bytesRemaining As Long)
'Debug.Print "SendProgress"

End Sub
